import processing.core.*; 

import javax.swing.filechooser.FileSystemView; 

import java.applet.*; 
import java.awt.Dimension; 
import java.awt.Frame; 
import java.awt.event.MouseEvent; 
import java.awt.event.KeyEvent; 
import java.awt.event.FocusEvent; 
import java.awt.Image; 
import java.io.*; 
import java.net.*; 
import java.text.*; 
import java.util.*; 
import java.util.zip.*; 
import java.util.regex.*; 

public class ddcacdd extends PApplet {




PGraphics positive;
PGraphics negative;
boolean toggle = false;
boolean mousePressedOnce = false;
boolean cursorHidden = false;

PImage dogCursor;
PImage catCursor;

int w = 600;
int h = 400;

public void setup() {

frame.setIconImage( getToolkit().getImage("icon.png"));
  
  size(680, 480, P2D);
  frameRate(60);
  frame.setTitle("Dog draws Cat.");
  
  catCursor = loadImage("cat_cursor.png");
  dogCursor = loadImage("dog_cursor.png");
  
  cursor(dogCursor, 7, 7);
  
  positive = createGraphics(w-80, h-80, P2D);
  negative = createGraphics(w-80, h-80, P2D);
  
  positive.beginDraw();
  positive.background(255);
  positive.endDraw();
  
  negative.beginDraw();
  negative.background(0);
  negative.endDraw();

  noStroke();
  background(0);
  fill(255);
  rect(40+width/2-w/2, 40+height/2-h/2, w-80, h-80);
}

public void draw() {
}

public void mousePressed() {
  cursor(dogCursor, 7, 7);
  render_cat();
}

public void mouseReleased() {
  cursor(catCursor, 7, 7);
  render_dog();
}

public void mouseMoved() {
  render_dog();
}

public void mouseDragged() {
  render_cat();
}

public void render_cat() {
  
  if (!mousePressedOnce) mousePressedOnce=true;
  frame.setTitle("Dog draws Cat.");
  background(0);
  positive.beginDraw();
  positive.stroke(0);
  positive.line(pmouseX-width/2+w/2-40, pmouseY-height/2+h/2-40, mouseX-width/2+w/2-40, mouseY-height/2+h/2-40);
  positive.endDraw();
  image(positive, 40+width/2-w/2, 40+height/2-h/2);
}

public void render_dog() {
  if (mousePressedOnce) {
    frame.setTitle("Cat draws Dog.");
    background(255);
    negative.beginDraw();
    negative.stroke(255);
    negative.line(pmouseX-width/2+w/2-40, pmouseY-height/2+h/2-40, mouseX-width/2+w/2-40, mouseY-height/2+h/2-40);
    negative.endDraw();
    image(negative, 40+width/2-w/2, 40+height/2-h/2);
  }
}

public void keyPressed() {

  switch(keyCode) {
  case ESC:
    stop();
    break;
  }
}

public void exit(){

  FileSystemView filesys = FileSystemView.getFileSystemView();
  positive.save(filesys.getHomeDirectory()+"/Desktop/Dog drew Cat.png");
  negative.save(filesys.getHomeDirectory()+"/Desktop/Cat drew Dog.png");
  System.exit(1);
}


  static public void main(String args[]) {
    PApplet.main(new String[] { "--bgcolor=#FFFFFF", "ddcacdd" });
  }
}
